#!/bin/bash
# RFT v2 Tutorial Launcher for macOS/Linux
# Run: bash tutorial/launch_tutorial.sh
# Or: chmod +x tutorial/launch_tutorial.sh && ./tutorial/launch_tutorial.sh

echo ""
echo "======================================"
echo "  RFT v2 Interactive Tutorial"
echo "======================================"
echo ""

# Check if Python is installed
if ! command -v python3 &> /dev/null; then
    echo "❌ ERROR: Python 3 is not installed"
    echo ""
    echo "Please install Python 3.7+ from https://python.org"
    exit 1
fi

# Check Python version
PYTHON_VERSION=$(python3 --version | cut -d' ' -f2 | cut -d'.' -f1,2)
echo "✅ Found Python $PYTHON_VERSION"

# Check if Streamlit is installed
if ! python3 -c "import streamlit" &> /dev/null; then
    echo "📦 Streamlit not found. Installing..."
    python3 -m pip install streamlit>=1.28.0
    echo "✅ Streamlit installed!"
fi

echo ""
echo "🚀 Launching tutorial..."
echo "📖 Your browser should open automatically."
echo ""
echo "💡 To stop: Press Ctrl+C in this terminal"
echo ""

# Get the directory of this script
SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

# Launch Streamlit
python3 -m streamlit run "$SCRIPT_DIR/app.py" \
    --theme.base dark \
    --theme.primaryColor "#64ffda" \
    --theme.backgroundColor "#0a0e27" \
    --theme.secondaryBackgroundColor "#1a1f3a"
