#!/usr/bin/env python3
"""
Tutorial Launcher for RFT v2 Galaxy Rotation Curves
Double-click this file (or run: python3 launch_tutorial.py)
"""

import subprocess
import sys
from pathlib import Path

def main():
    # Get tutorial directory
    tutorial_dir = Path(__file__).parent
    app_path = tutorial_dir / "app.py"

    # Check if streamlit is installed
    try:
        import streamlit
    except ImportError:
        print("❌ Streamlit not found!")
        print("\n📦 Installing Streamlit...")
        subprocess.run([sys.executable, "-m", "pip", "install", "streamlit>=1.28.0"])
        print("\n✅ Streamlit installed!")

    # Launch the tutorial
    print("🚀 Launching RFT v2 Interactive Tutorial...")
    print("📖 Your browser should open automatically.")
    print("\n💡 To stop: Press Ctrl+C in this window\n")

    subprocess.run([
        sys.executable, "-m", "streamlit", "run",
        str(app_path),
        "--theme.base", "dark",
        "--theme.primaryColor", "#64ffda",
        "--theme.backgroundColor", "#0a0e27",
        "--theme.secondaryBackgroundColor", "#1a1f3a"
    ])

if __name__ == "__main__":
    main()
