@echo off
REM RFT v2 Tutorial Launcher for Windows
REM Double-click this file to launch the tutorial

echo.
echo ======================================
echo   RFT v2 Interactive Tutorial
echo ======================================
echo.

REM Check if Python is installed
python --version >nul 2>&1
if errorlevel 1 (
    echo ERROR: Python is not installed or not in PATH
    echo.
    echo Please install Python 3.7+ from https://python.org
    pause
    exit /b 1
)

REM Check if Streamlit is installed
python -c "import streamlit" >nul 2>&1
if errorlevel 1 (
    echo Streamlit not found. Installing...
    python -m pip install streamlit>=1.28.0
)

echo.
echo Launching tutorial...
echo Your browser should open automatically.
echo.
echo To stop: Close this window or press Ctrl+C
echo.

REM Launch Streamlit
python -m streamlit run "%~dp0app.py" --theme.base dark --theme.primaryColor "#64ffda" --theme.backgroundColor "#0a0e27"

pause
