# RFT v2 Interactive Tutorial

**Version**: 2.2.2
**Type**: Interactive web-based tutorial (Streamlit app)
**Requirements**: Python 3.7+, Streamlit
**Duration**: ~30 minutes (self-paced)

---

## 🚀 Quick Start (One Command)

### Option 1: Double-Click Launch (Easiest)

**Windows**:
1. Double-click `launch_tutorial.py`
2. Tutorial opens in your browser automatically

**Mac/Linux**:
1. Right-click `launch_tutorial.py` → "Open With" → Python
2. Or run from terminal: `python3 tutorial/launch_tutorial.py`

### Option 2: Command Line

```bash
# Install Streamlit (if needed)
pip install streamlit

# Launch tutorial
streamlit run tutorial/app.py
```

The tutorial will open in your default web browser at `http://localhost:8501`.

---

## 📚 What's Included

### Tutorial Sections

1. **🏠 Welcome** - Overview and learning objectives
2. **📚 Background & Physics** - Dark matter problem, rotation curves, three paradigms
3. **🔬 Methodology** - k=0 fairness, TRAIN/TEST splits, statistical tests
4. **▶️ Run the Auditor** - One-click verification of all claims
5. **🌠 Explore Galaxies** - Hands-on galaxy rotation curve analysis
6. **📊 Results & Statistics** - Aggregate performance, confidence intervals
7. **💡 LSB vs HSB** - Why RFT excels on low surface brightness galaxies
8. **❓ FAQ** - Physics, methods, software, troubleshooting
9. **🚀 What's Next** - Critical next tests, how to contribute

### Interactive Features

✅ **Run Auditor Button** - Execute `audit/audit_all.py` with live output
✅ **Galaxy Explorer** - (Coming soon: select and plot individual galaxies)
✅ **Statistical Dashboards** - Pass rates, Wilson CIs, McNemar tests
✅ **Tooltips & Explanations** - Hover over technical terms
✅ **Copy-Paste Code** - All commands are ready to copy

---

## 🎯 Learning Path

### Beginners (30 minutes)
1. Welcome → Background → Methodology → Run Auditor → Results → FAQ
2. Focus on understanding **what** RFT v2 is and **why** the method is rigorous

### Intermediate (60 minutes)
1. Full tutorial from start to finish
2. Run the auditor manually (command line)
3. Explore 2-3 individual galaxies
4. Dive into LSB vs HSB physics

### Advanced (90+ minutes)
1. Complete tutorial + hands-on exercises
2. Run solver on all 34 TEST galaxies
3. Reproduce statistical tests manually
4. Read the codebase and extend the tutorial

---

## 🔧 Requirements

**Minimum**:
- Python 3.7+
- Streamlit (`pip install streamlit`)
- Web browser (Chrome, Firefox, Safari, Edge)

**Recommended**:
- Python 3.11+
- NumPy/SciPy (for running the full solver, not required for auditor)
- 4 GB RAM
- 1 GB disk space

**Optional** (for packaging):
- PyInstaller (to create standalone executables)

---

## 📦 Packaging as Executable

To create a standalone double-click launcher (no Python installation needed):

### Windows .exe

```bash
pip install pyinstaller
pyinstaller --onefile --windowed tutorial/launch_tutorial.py
# Output: dist/launch_tutorial.exe
```

### macOS .app

```bash
pip install pyinstaller
pyinstaller --onefile --windowed --name "RFT Tutorial" tutorial/launch_tutorial.py
# Output: dist/RFT Tutorial.app
```

### Linux Binary

```bash
pip install pyinstaller
pyinstaller --onefile tutorial/launch_tutorial.py
# Output: dist/launch_tutorial
```

---

## 🐛 Troubleshooting

### Tutorial won't start

**Problem**: `ModuleNotFoundError: No module named 'streamlit'`
**Solution**: Install Streamlit: `pip install streamlit`

**Problem**: Port 8501 already in use
**Solution**: Stop other Streamlit apps or use custom port: `streamlit run tutorial/app.py --server.port 8502`

### Auditor button doesn't work

**Problem**: `FileNotFoundError: audit/audit_all.py`
**Solution**: Make sure you're running from the repository root (not inside /tutorial)

**Problem**: Auditor fails with errors
**Solution**: Check Python version (3.7+). Verify file integrity with `sha256sum`.

### Plots don't show

**Problem**: Blank plot area
**Solution**: (Coming in v2.2.3) The interactive plot viewer requires matplotlib. For now, use command-line plotting.

---

## 🎨 Customization

### Theme

Edit the launch script to change colors:

```python
subprocess.run([
    sys.executable, "-m", "streamlit", "run", str(app_path),
    "--theme.primaryColor", "#ff6b6b",  # Change this
    "--theme.backgroundColor", "#1a1a2e"  # And this
])
```

### Content

Edit `tutorial/app.py` to modify tutorial content. All text is in Markdown for easy editing.

---

## 📖 Structure

```
tutorial/
├── README.md               # This file
├── app.py                  # Main Streamlit app (all content)
├── launch_tutorial.py      # One-click launcher script
├── requirements.txt        # Python dependencies
├── pages/                  # (Future: separate page files)
├── assets/                 # (Future: images, diagrams)
└── data/                   # (Future: cached results)
```

---

## 🤝 Contributing

Want to improve the tutorial?

1. **Content**: Edit `app.py` to fix typos, add examples, clarify explanations
2. **Visuals**: Add plots to `assets/` and reference them in the app
3. **Interactivity**: Implement the galaxy explorer (plot rendering with matplotlib/plotly)
4. **Translations**: Create language-specific versions

Open a GitHub issue or PR with your changes!

---

## 📜 License

MIT License (same as main repository)

---

## 🌟 Credits

**Tutorial Content**: Based on GPT-generated comprehensive content (see /GPT_TUTORIAL_REQUEST.md)
**Physics**: RFT v2 framework by the RFT Cosmology Team
**Data**: SPARC galaxy rotation curves (Lelli et al. 2016)
**Framework**: Streamlit (open-source Python web framework)

---

## 📞 Support

- **GitHub Issues**: https://github.com/RFT-Cosmology/rft-v2-galaxy-rotations/issues
- **Email**: research@rft-cosmology.com
- **Website**: https://rft-cosmology.com

---

**Ready to learn?** Run `python3 tutorial/launch_tutorial.py` and explore the dark matter alternative! 🌌
