#!/bin/bash
# Test the publication API by publishing Volume 1 and Volume 2

API_URL="http://127.0.0.1:5000/api/publish"
API_KEY="omega-portal-key-2025"

echo "=========================================="
echo "Testing Publication Workflow"
echo "=========================================="
echo ""

# Test 1: Publish Volume 1
echo "📤 Publishing Volume 1: RFT RC11..."
curl -s -X POST "${API_URL}/volume" \
  -H "Content-Type: application/json" \
  -d '{
    "api_key": "omega-portal-key-2025",
    "source_slug": "rft-volume1-rc11",
    "publication": {
      "slug": "rft-volume1-rc11",
      "title": "Resonant Field Theory, Volume 1: Unified Field Dynamics",
      "short_title": "RFT Volume 1",
      "subtitle": "Scalaron–Twistor Spacetime, Environmental Screening, and Observational Gates",
      "version": "v1.0-rc11",
      "status": "Preprint",
      "release_date": "2025-09-21",
      "authors": ["Ian Fitzpatrick"],
      "summary": "Establishes the scalaron–twistor lattice as a unified description of gravity and gauge sectors, demonstrating emergent spacetime, environmental screening, and preregistered observational gates that match Cassini, Planck, and SPARC data.",
      "highlights": [
        "Derives Einstein limits from scalaron–twistor thermodynamics while keeping spacetime discrete at the microscale.",
        "Demonstrates screened modified gravity consistent with Solar System constraints yet reproducing galaxy rotation curves and stacked weak lensing.",
        "Shows E₈→E₆×SU(3) breaking yields three fermion generations and Dirac-only neutrinos, with deterministic build harness for reproducibility."
      ],
      "tags": ["modified-gravity", "screening", "emergent-spacetime", "volume-1"],
      "metrics": {
        "page_count": 140,
        "word_count": 2390
      },
      "artifacts": {
        "source_repo": "https://github.com/rft-cosmology/rft-vol1-rc11",
        "repro_repo": "https://github.com/rft-cosmology/rft-vol1-proofpack"
      }
    }
  }' | python3 -m json.tool

echo ""
echo "=========================================="
echo ""

# Test 2: Publish Volume 2
echo "📤 Publishing Volume 2: RFT RC12..."
curl -s -X POST "${API_URL}/volume" \
  -H "Content-Type: application/json" \
  -d '{
    "api_key": "omega-portal-key-2025",
    "source_slug": "rft-volume2-rc12",
    "publication": {
      "slug": "rft-volume2-rc12",
      "title": "Resonant Field Theory, Volume 2: Geometric Necessity",
      "short_title": "RFT Volume 2",
      "subtitle": "Constants from Geometry, Embedding Uniqueness, and Nuclear Closures",
      "version": "v2.0-rc12",
      "status": "Preprint",
      "release_date": "2025-09-30",
      "authors": ["Ian Fitzpatrick"],
      "summary": "Derives the five fundamental constants (ℏ, α, mₑ/mₚ, c, G) as geometric consequences of the scalaron–twistor lattice, links SU(3) instantons to family replication, and presents nuclear shell closures from Platonic geometry.",
      "highlights": [
        "Shows ℏ and α emerge from CP¹ Berry holonomy and dual polyhedral closure, matching CODATA at sub-ppm precision without parameter tuning.",
        "Solves a 3×3 lattice eigenproblem for the 1836:1 mass hierarchy and relates BAO, growth, and dark energy parameters to the frozen ledger.",
        "Provides falsifiable predictions and automated uncertainty budgets with reproducible build stamps and ablation tests on lattice geometry."
      ],
      "tags": ["fundamental-constants", "lattice-geometry", "volume-2"],
      "metrics": {
        "page_count": 50,
        "word_count": 1825
      },
      "artifacts": {
        "determinism_stamp": "/home/rftuser/rft-vol2-arxiv/rft-rc12-mini/stamps/determinism.txt",
        "source_repo": "https://github.com/rft-cosmology/rft-vol2-arxiv",
        "repro_repo": "https://github.com/rft-cosmology/rft-vol2-proofpack"
      }
    }
  }' | python3 -m json.tool

echo ""
echo "=========================================="
echo ""

# Test 3: Check publication status
echo "✅ Checking publication status..."
echo ""
echo "Volume 1 status:"
curl -s "${API_URL}/status/rft-volume1-rc11" | python3 -m json.tool
echo ""
echo "Volume 2 status:"
curl -s "${API_URL}/status/rft-volume2-rc12" | python3 -m json.tool

echo ""
echo "=========================================="
echo "✅ Tests complete!"
echo "=========================================="
echo ""
echo "View publications at: http://127.0.0.1:5000/publications"
echo ""
