#!/bin/bash
# Setup nightly backup cron job

SCRIPT_DIR="/home/rftuser/rft-cosmology-site/scripts"
BACKUP_SCRIPT="$SCRIPT_DIR/nightly_backup.sh"
LOG_FILE="/home/rftuser/backups/backup.log"

echo "Setting up nightly backup cron job..."

# Create log directory
mkdir -p /home/rftuser/backups

# Add cron job (runs at 2:30 AM daily)
(crontab -l 2>/dev/null; echo "30 2 * * * $BACKUP_SCRIPT >> $LOG_FILE 2>&1") | crontab -

echo "✅ Cron job added successfully!"
echo "📅 Backup will run daily at 2:30 AM"
echo "📝 Logs will be written to: $LOG_FILE"
echo ""
echo "To check cron jobs: crontab -l"
echo "To test backup now: $BACKUP_SCRIPT"
echo "To view logs: tail -f $LOG_FILE"