#!/bin/bash
# Monitor C10.2 grid search progress

echo "=== C10.2 Grid Search Progress Monitor ==="
echo ""

# Count completed configs by checking how many times summary was written
if [ -f "reports/_summary_C10P_TRAIN.json" ]; then
  # Check modification time
  mod_time=$(stat -c %y reports/_summary_C10P_TRAIN.json | cut -d. -f1)
  echo "Last update: $mod_time"
  echo ""

  # Extract current best result
  passes=$(jq '[.rows[] | select(.solvers.rft_geom.rms_pct<=20)] | length' reports/_summary_C10P_TRAIN.json 2>/dev/null || echo "0")
  total=$(jq '.solver_totals.rft_geom.n_cases' reports/_summary_C10P_TRAIN.json 2>/dev/null || echo "0")
  medrms=$(jq '.solver_totals.rft_geom.rms_pct_median' reports/_summary_C10P_TRAIN.json 2>/dev/null || echo "0")

  if [ "$total" -gt 0 ]; then
    pct=$(python3 -c "print(f'{$passes*100.0/$total:.1f}')" 2>/dev/null || echo "0.0")
    echo "Current result: $passes/$total @ 20% = $pct%"
    echo "Median RMS: $medrms%"
  else
    echo "No results yet (initializing...)"
  fi
else
  echo "No summary file yet - grid search still initializing"
fi

echo ""
echo "Process status:"
ps aux | grep -E "grid_search_c10p|rft_rc_bench" | grep -v grep | head -5

echo ""
echo "Expected: 24 configs × ~2-3 min/config = 48-72 minutes total"
echo "Use Ctrl+C to exit monitoring (grid continues in background)"
