#!/bin/bash
# Generate version.json for build timestamp and tracking

# Get current date/time in UTC
BUILD_DATE=$(date -u +%Y-%m-%dT%H:%MZ)

# Get short commit hash (or 'local' if not in git)
COMMIT_HASH=$(git rev-parse --short HEAD 2>/dev/null || echo "local")

# Get the latest tag or version number
TAG=$(git describe --tags --abbrev=0 2>/dev/null || echo "v1.0.0")

# Try to get papers sync date from papers.json if it exists
PAPERS_SYNC="unknown"
if [ -f "app/static/data/papers.json" ]; then
    # Extract last publication date from papers.json
    PAPERS_SYNC=$(python3 -c "
import json
import sys
try:
    with open('app/static/data/papers.json', 'r') as f:
        papers = json.load(f)
        if papers and len(papers) > 0:
            # Get the most recent paper date
            dates = [p.get('pubDate', '') for p in papers if p.get('pubDate')]
            if dates:
                print(sorted(dates)[-1])
            else:
                print('unknown')
        else:
            print('unknown')
except:
    print('unknown')
" 2>/dev/null || echo "unknown")
fi

# Create the output directory if it doesn't exist
mkdir -p app/static

# Generate version.json
cat > app/static/version.json << EOF
{
  "build": "$BUILD_DATE",
  "commit": "$COMMIT_HASH",
  "papersSync": "$PAPERS_SYNC",
  "tag": "$TAG"
}
EOF

echo "Generated version.json:"
cat app/static/version.json