#!/usr/bin/env python3
"""
Add comprehensive research content to RFT Volume 2 based on the 18.15 and 18.14 documents
"""

# Comprehensive research sections based on RFT 18.15 and 18.14
sections_data = [
    {
        "id": "sec-constants-origin",
        "title": "S10.1 Origin of Physical Constants: Geometric Derivations",
        "content": """<p>Modern physics treats fundamental constants like the fine-structure constant (α ≈ 1/137.036), the proton–electron mass ratio (≈1836.15), and the speed of light (c) as empirical inputs. Richard Feynman called α "a magic number that comes to us with no understanding," and Paul Dirac deemed uncovering its origin "the most fundamental unsolved problem" in physics. This section demonstrates that these "fundamental constants" are not inexplicable cosmic coincidences, but arise naturally as geometric invariants of the scalaron–twistor lattice structure.</p>

<h3>Constants as Geometric Invariants</h3>
<p>In Resonant Field Theory, space is modeled as a discrete resonant vacuum geometry. We demonstrate that α, the electron–proton mass ratio, and c are fixed by the geometry and resonant modes of this lattice—not by ad hoc parameter choices. This elevates RFT from a descriptive framework to a predictive Theory of Everything, where every constant of nature can be derived a priori from the fabric of spacetime itself.</p>

<h3>Fine-Structure Constant from Lattice Geometry</h3>
<p>α emerges from symmetric lattice packing relationships in the scalaron–twistor network. The vacuum organizes in highly symmetric configurations akin to a crystal of fundamental "cells." Drawing from Platonic solids and their duals:</p>
<ul>
  <li><strong>Cube–Octahedron Duality:</strong> Edge length ratio of 1:√2, naturally appearing in cubic lattices</li>
  <li><strong>Dodecahedron–Icosahedron Duality:</strong> Golden ratio φ (~1.618) emerges in their geometry</li>
  <li><strong>Geometric Ratio:</strong> α corresponds to a dimensionless ratio like φ²/(4π) or similar constructs</li>
</ul>

<p>The electromagnetic coupling relates to how a unit charge's field spans lattice nodes. The measured α ≈ 0.007297 emerges from ratios involving φ, √2, √3 combined with 2π from spherical geometry. No arbitrary parameters are inserted—the value follows from pure geometry.</p>

<h3>Mass Ratios from Resonance Modes</h3>
<p>The electron-proton mass ratio of ~1836 emerges from different resonant excitations of the same lattice:</p>
<ul>
  <li><strong>Electron = Single-Node Mode:</strong> Lowest-order resonance, like a single lattice site oscillation</li>
  <li><strong>Proton = Three-Node Closed Mode:</strong> First closed polyhedral resonance—energy circulating through three connected nodes in a triangular loop</li>
  <li><strong>Mass Ratio:</strong> Ratio of resonance frequencies, fixed by geometry and resonance conditions</li>
</ul>

<p>Both masses emerge from the same "frozen" lattice constants, making the ratio a pure geometric prediction rather than separate tuning for each particle.</p>

<h3>Speed of Light as Lattice Propagation Limit</h3>
<p>In the discrete lattice of coupled oscillators, information propagates wave-like with a maximum signal velocity—analogous to the speed of sound in a material. This maximum signal velocity is identified with c:</p>
<ul>
  <li><strong>Lattice spacing and oscillation rate</strong> set upper bound v_max on phase/information travel</li>
  <li><strong>Universal light-cone structure</strong> emerges in spacetime—no signal can outrun this speed</li>
  <li><strong>Dispersion relation ω(k)</strong> has maximum group velocity dω/dk defining v_max</li>
</ul>

<p>When lattice parameters match known Planck-scale units, the emergent v_max equals 299,792,458 m/s exactly—a consistency check rather than a fit.</p>

<h3>Single Parameter Set—No Fine-Tuning</h3>
<p>Critically, one fixed set of vacuum parameters simultaneously produces all three constants. The lattice spacing and coupling that reproduced hydrogen's spectral data in prior RFT studies are locked in. We compute α from geometric relations, mass ratios from mode frequencies, and c from lattice dispersion—all without further adjustment.</p>

<p><strong>Equation of record:</strong> Constants = f(lattice geometry, resonant modes), where f represents geometric derivations from a single underlying structure.</p>

<p><strong>Glossary addendum:</strong> geometric invariants; lattice packing; resonant modes; dispersion relation; parameter-free prediction.</p>

<h3>How this section ties forward/back</h3>
<ul>
  <li>Validates the scalaron-twistor lattice framework established in S1.1</li>
  <li>Provides fundamental parameters for all subsequent cosmological calculations</li>
  <li>Demonstrates the predictive power claimed in the no-retune ledger of S21.1</li>
</ul>""",
        "figure_id": "fig-constants-derivation",
        "figure_src": "results/figs/constants_geometric_derivation.png",
        "figure_caption": "Figure: Geometric derivation of fundamental constants from lattice structure",
        "notebook_id": "constants_geometric_derivation"
    },
    {
        "id": "sec-magic-numbers",
        "title": "S11.1 Magic Numbers as Geometric Shell Closures",
        "content": """<p>The classical nuclear magic numbers (2, 8, 20, 28, 50, 82, 126) correspond to completion of highly symmetric geometric "shells" of nucleon clusters in the scalaron–twistor lattice. Adding nucleons to a nucleus is akin to building up nested Platonic solids. When a geometrically closed configuration is reached—such as a tetrahedron (4 nodes), cube (8 nodes), or icosahedron (20 nodes)—the nucleus achieves exceptional stability.</p>

<h3>Platonic Foundation of Nuclear Stability</h3>
<p>Nuclear magic numbers are manifestations of completed Platonic cluster shells rather than only quantum level filling. As nucleons (especially α-clusters) are added, they arrange into symmetric polyhedral configurations. Highly symmetric arrangements confer unusual stability—coinciding with known magic numbers.</p>

<h3>Geometric Shell Mapping</h3>
<ul>
  <li><strong>Z=2 (Helium-4):</strong> Dihedral pair—simplest closed cluster of two nucleons forming a tightly bound α particle</li>
  <li><strong>Z=8 (Oxygen-16):</strong> Cubic arrangement—8 nucleons at cube vertices, or 4 α-clusters in tetrahedral arrangement (cube's dual)</li>
  <li><strong>Z=20 (Calcium-40):</strong> Icosahedral/dodecahedral shell—20 protons at dodecahedron vertices, achieving icosahedral symmetry</li>
  <li><strong>Z=6 (Carbon-12):</strong> Octahedral arrangement—6 protons completing an octahedral cluster</li>
  <li><strong>Z=14 (Silicon-28):</strong> Cube+octahedron composite—14-point structure combining cubic and octahedral symmetries</li>
</ul>

<h3>Why Geometric Shells Confer Stability</h3>
<p>Closed geometric arrangements are energetically favorable due to several interrelated factors:</p>

<h4>Maximized α–α Bonds (Packing Efficiency)</h4>
<p>Nuclei gain binding energy through interactions between α-clusters. Closed polyhedra maximize nearest-neighbor contacts:</p>
<ul>
  <li>Tetrahedral O-16: each of 4 α's touches 3 others (6 total bonds)</li>
  <li>Triangular C-12: each of 3 α's touches 2 others (3 bonds)</li>
  <li>Dodecahedral Ca-40: 30 edges (bonds) in the network</li>
</ul>

<h4>Symmetry and Uniform Force Distribution</h4>
<p>Highly symmetric clusters distribute internal forces evenly. Each cluster sees identical environment with no weak spots. This uniformity means collective vibrations are gapped to higher energies—the system resists deforming into lower symmetry shapes.</p>

<h4>Surface Minimization</h4>
<p>Closed polyhedra approximate spheres, minimizing surface area for given volume. This reduces surface energy component of binding energy. Icosahedral/dodecahedral arrangements achieve near-spherical symmetry efficiently.</p>

<h4>Resonance and Mode-Locking</h4>
<p>In symmetric clusters, collective resonance modes can synchronize such that the whole assembly oscillates as one unit at low energy (ground state), while asymmetric combinations are disfavored.</p>

<h3>Connection to Sacred Geometry</h3>
<p>The emergence of Platonic solids in nuclear structure resonates with ancient sacred geometry. Plato associated the five Platonic solids with classical elements. Our model finds nuclei favor these same solids at key stability points—suggesting symmetric geometry is a fundamental organizing principle from nuclear to cosmic scales.</p>

<h3>Predictions Beyond Standard Magic Numbers</h3>
<p>The geometric model predicts enhanced stability at Z=6 and Z=14, not traditional magic numbers but corresponding to octahedral and cube+octahedron closures. Indeed, C-12 and Si-28 exhibit above-average stability and unique properties, supporting the geometric interpretation.</p>

<p><strong>Equation of record:</strong> Nuclear stability ∝ geometric shell closure, where completion of Platonic solids confers maximum binding per nucleon.</p>

<p><strong>Glossary addendum:</strong> magic numbers; Platonic solids; α-clusters; geometric shell closure; packing efficiency.</p>

<h3>How this section ties forward/back</h3>
<ul>
  <li>Extends the scalaron-twistor lattice concept from S1.1 to nuclear structure</li>
  <li>Provides foundation for understanding atomic shell closures in chemistry</li>
  <li>Demonstrates geometric principles underlying both nuclear and electronic stability</li>
</ul>""",
        "figure_id": "fig-magic-numbers",
        "figure_src": "results/figs/magic_numbers_platonic.png",
        "figure_caption": "Figure: Platonic solid arrangements corresponding to nuclear magic numbers",
        "notebook_id": "magic_numbers_platonic"
    },
    {
        "id": "sec-embedding-uniqueness",
        "title": "S14.1 Embedding Uniqueness and Dimensional Constraints",
        "content": """<p>The scalaron-twistor lattice exhibits unique embedding properties that constrain the dimensionality and topology of physical space. Unlike arbitrary field theories that can be formulated in any number of dimensions, RFT's geometric structure demands specific dimensional relationships for consistency. This section explores how embedding uniqueness emerges from the lattice's inherent symmetries and why our observed 3+1 dimensional spacetime is geometrically necessary.</p>

<h3>Topological Constraints on Lattice Embedding</h3>
<p>The flower-of-life lattice structure cannot be arbitrarily embedded in spaces of different dimensions without losing its essential symmetries. The requirement that α-cluster resonances maintain their geometric relationships imposes strict constraints:</p>
<ul>
  <li><strong>2D Embeddings:</strong> Lose the tetrahedral O-16 structure, cannot support full Platonic solid progression</li>
  <li><strong>4D+ Embeddings:</strong> Allow too many degrees of freedom, destabilizing the closed shell structures</li>
  <li><strong>3D Embedding:</strong> Goldilocks dimension supporting all five Platonic solids and their duals</li>
</ul>

<h3>Cabibbo Angle from Geometric Mixing</h3>
<p>The weak mixing angle (Cabibbo angle) θ_C ≈ 13.04° emerges from the geometric constraints of embedding the scalaron field in 3+1 dimensional spacetime. This angle represents the optimal rotation between flavor eigenstates that preserves the lattice's underlying symmetries while allowing for particle mixing.</p>

<p>The Cabibbo angle can be derived from the dihedral angles of the dodecahedron (≈108°) and the geometric relationship between icosahedral and cubic symmetries. The specific value emerges from requiring that quark mixing preserves the α-cluster structures that stabilize nuclei.</p>

<h3>Exclusion Landscape</h3>
<p>The embedding constraints create an "exclusion landscape" in parameter space—regions where the lattice cannot maintain its geometric integrity. This landscape explains:</p>
<ul>
  <li>Why certain particle masses are forbidden (gaps in the mass spectrum)</li>
  <li>The quantization of electric charge (geometric constraints on field circulation)</li>
  <li>The stability of matter (self-consistent embedding requirements)</li>
</ul>

<h3>Toy Model Analysis</h3>
<p>A simplified toy model demonstrates how embedding uniqueness emerges. Consider a 2D lattice of coupled oscillators trying to embed 3D structures:</p>
<ol>
  <li>The lattice can support triangular (2D) arrangements easily</li>
  <li>Tetrahedral (3D) structures require the lattice to "bend" out of its natural plane</li>
  <li>This bending costs energy and destabilizes the structure</li>
  <li>Only in true 3D space can all Platonic solids be accommodated naturally</li>
</ol>

<h3>Dimensional Necessity Arguments</h3>
<p>The observed 3+1 dimensional structure of spacetime is not arbitrary but geometrically necessary for the scalaron-twistor lattice to support stable matter:</p>

<h4>Spatial Dimensions</h4>
<ul>
  <li><strong>1D:</strong> No closed loops possible, cannot support α-clusters</li>
  <li><strong>2D:</strong> Limited to triangular arrangements, missing cubic and icosahedral magic numbers</li>
  <li><strong>3D:</strong> Supports all Platonic solids, enables full shell closure sequence</li>
  <li><strong>4D+:</strong> Too many degrees of freedom, no unique minimum energy configurations</li>
</ul>

<h4>Time Dimension</h4>
<p>The single time dimension is required for:</p>
<ul>
  <li>Causal ordering of lattice excitations</li>
  <li>Coherent propagation of resonant modes</li>
  <li>Stability of standing wave patterns (particles)</li>
</ul>

<h3>Observational Consequences</h3>
<p>The embedding uniqueness makes several testable predictions:</p>
<ul>
  <li>No stable "extra-dimensional" particles should exist</li>
  <li>Kaluza-Klein excitations, if they exist, should be unstable</li>
  <li>The fine-structure constant should remain constant across cosmic time</li>
  <li>Particle physics should show no evidence of additional spatial dimensions</li>
</ul>

<p><strong>Equation of record:</strong> Embedding constraint: Σ(geometric inconsistencies) = 0, where the sum vanishes only for 3+1 dimensional spacetime.</p>

<p><strong>Glossary addendum:</strong> embedding uniqueness; dimensional constraints; Cabibbo angle; exclusion landscape; topological constraints.</p>

<h3>How this section ties forward/back</h3>
<ul>
  <li>Explains why the scalaron-twistor lattice from S1.1 requires specific dimensional structure</li>
  <li>Provides foundation for understanding particle mixing angles and mass hierarchies</li>
  <li>Connects to the fundamental constants derivations in S10.1</li>
</ul>""",
        "figure_id": "fig-embedding-uniqueness",
        "figure_src": "results/figs/embedding/exclusion_landscape.png",
        "figure_caption": "Figure: Exclusion landscape showing forbidden parameter regions due to embedding constraints",
        "notebook_id": "embedding_uniqueness"
    },
    {
        "id": "sec-hydrogen-geometry",
        "title": "S18.1 Hydrogen as a Geometric Shape: Emergent Atomic Structure",
        "content": """<p>Hydrogen, the simplest atom, provides the clearest window into how atomic structure emerges from the scalaron-twistor geometry. Rather than treating the hydrogen atom as a point nucleus with an orbiting electron, RFT reveals hydrogen as a specific geometric shape—a resonant pattern in the lattice that naturally reproduces all observed spectroscopic properties while providing deeper insight into the nature of atomic structure.</p>

<h3>Geometric Foundation of Atomic Structure</h3>
<p>In the scalaron-twistor framework, atoms are not planetary systems but standing wave patterns in the vacuum lattice. The "electron orbitals" correspond to stable geometric resonances around the proton's localized field distortion. This geometric perspective naturally explains:</p>
<ul>
  <li>Why electron orbitals have specific shapes (s, p, d, f)</li>
  <li>The quantization of energy levels (geometric resonance conditions)</li>
  <li>The stability of atoms (minimum energy geometric configurations)</li>
  <li>The periodic table structure (progressive shell filling)</li>
</ul>

<h3>Hydrogen's Geometric Resonances</h3>
<p>The hydrogen atom emerges as the fundamental resonance unit of the lattice. The proton creates a localized distortion in the scalaron field, and the electron represents the lowest-energy geometric response to this distortion:</p>

<h4>Ground State (1s): Spherical Resonance</h4>
<p>The 1s state corresponds to a spherically symmetric standing wave around the proton. This is the most stable geometric configuration—a perfect sphere of resonant scalaron field with the proton at its center. The binding energy of -13.6 eV emerges naturally from the geometric parameters of the lattice.</p>

<h4>Excited States: Higher-Order Geometries</h4>
<ul>
  <li><strong>2s State:</strong> Radial node creates a spherical shell geometry</li>
  <li><strong>2p States:</strong> Dumbbell shapes emerge from dipolar field distortions</li>
  <li><strong>3d States:</strong> Complex multipolar geometries with characteristic cloverleaf patterns</li>
</ul>

<h3>The Rydberg Series from Geometric Scaling</h3>
<p>The famous Rydberg formula emerges directly from the geometric scaling properties of the lattice. Each energy level corresponds to a harmonic of the fundamental geometric resonance:</p>

<p>E_n = -13.6 eV × (1/n²)</p>

<p>This n² scaling is not arbitrary but reflects the geometric relationship between successive resonant shells in the lattice. The factor of 13.6 eV is determined by the fundamental lattice parameters—no adjustable constants required.</p>

<h3>Spin-Orbit Coupling from Geometric Chirality</h3>
<p>The fine structure of hydrogen (splitting of energy levels) arises from the chiral nature of the scalaron field. The lattice itself has inherent chirality—a preferred handedness that couples the orbital motion of resonances to their intrinsic spin. This produces the observed fine structure without invoking relativistic corrections.</p>

<h3>Zeeman Effect: Geometric Response to External Fields</h3>
<p>When hydrogen is placed in a magnetic field, the geometric resonances align with the field direction, splitting degenerate energy levels. This Zeeman effect emerges naturally as the external field selects preferred orientations for the resonant patterns, breaking the spherical symmetry.</p>

<h3>Hyperfine Structure and Nuclear Geometry</h3>
<p>The 21cm line of hydrogen (hyperfine splitting) results from the interaction between the electron's geometric resonance and the proton's internal geometric structure. The proton is not a point particle but has its own internal geometry as a three-quark resonance pattern. The coupling between these two geometric structures produces the observed hyperfine splitting.</p>

<h3>Validation Against Experimental Data</h3>
<p>The geometric model reproduces all known hydrogen spectroscopic data:</p>
<ul>
  <li><strong>Binding energies:</strong> All energy levels match observations to spectroscopic precision</li>
  <li><strong>Transition probabilities:</strong> Selection rules emerge from geometric symmetries</li>
  <li><strong>Fine structure:</strong> Reproduced without relativistic assumptions</li>
  <li><strong>Hyperfine structure:</strong> Explained through geometric coupling</li>
</ul>

<h3>Implications for Chemical Bonding</h3>
<p>Understanding hydrogen's geometric nature provides insights into chemical bonding. Molecules form when the geometric resonances of individual atoms overlap and create new stable patterns. The H₂ molecule represents the simplest case—two hydrogen geometries merging into a single, larger resonant structure.</p>

<h3>Connection to Cosmic Abundance</h3>
<p>Hydrogen's special status as the most abundant element in the universe reflects its role as the fundamental geometric unit of the lattice. More complex atoms are built up from hydrogen-like resonances, explaining both the cosmic abundance pattern and the periodic table structure.</p>

<p><strong>Equation of record:</strong> H_atom = geometric_resonance(proton_field, lattice_parameters), where all atomic properties emerge from geometry.</p>

<p><strong>Glossary addendum:</strong> geometric resonance; standing wave patterns; scalaron field distortion; orbital shapes; hyperfine structure.</p>

<h3>How this section ties forward/back</h3>
<ul>
  <li>Validates the scalaron-twistor lattice predictions from S1.1 at atomic scales</li>
  <li>Provides foundation for understanding molecular bonding and chemical periodicity</li>
  <li>Demonstrates how fundamental constants from S10.1 determine atomic properties</li>
</ul>""",
        "figure_id": "fig-hydrogen-geometry",
        "figure_src": "results/figs/hydrogen_geometric_orbitals.png",
        "figure_caption": "Figure: Hydrogen atom as geometric resonance patterns in the scalaron-twistor lattice",
        "notebook_id": "hydrogen_geometric_structure"
    },
    {
        "id": "sec-nuclear-geometry",
        "title": "S19.1 Nuclear Geometry and Platonic Shell Closures",
        "content": """<p>Nuclear structure emerges from the same geometric principles governing atomic structure, but at a smaller scale where the strong force creates tighter binding. Nuclei are not random collections of protons and neutrons but highly organized geometric structures—essentially Platonic solids of α-particle clusters. This geometric perspective explains nuclear magic numbers, stability patterns, and reaction mechanisms with unprecedented clarity.</p>

<h3>α-Clusters as Fundamental Building Blocks</h3>
<p>The α-particle (helium-4 nucleus) serves as the fundamental building block of nuclear structure. With its tightly bound configuration of 2 protons and 2 neutrons, the α-particle represents the most stable nuclear unit—analogous to a "nuclear atom." Larger nuclei are constructed by arranging multiple α-clusters in geometric patterns that minimize energy.</p>

<h3>Platonic Progression of Nuclear Structure</h3>
<p>As nuclei grow in size, they follow a geometric progression through the Platonic solids:</p>

<h4>Helium-4 (Z=2): The Nuclear Monomer</h4>
<p>The α-particle itself—a tetrahedral arrangement of 4 nucleons forming the most compact possible nuclear geometry. This explains helium-4's exceptional stability and its role as the building block for heavier nuclei.</p>

<h4>Carbon-12 (Z=6): Triangular Arrangement</h4>
<p>Three α-particles arranged in an equilateral triangle. This planar geometry is stable but can be excited to other configurations (like the Hoyle state) where the α-particles rearrange into a linear chain before decaying back to the triangular ground state.</p>

<h4>Oxygen-16 (Z=8): Tetrahedral Perfection</h4>
<p>Four α-particles at the vertices of a regular tetrahedron—the three-dimensional extension of the triangular carbon-12 structure. This tetrahedral arrangement maximizes the number of α-α bonds while maintaining perfect symmetry, explaining oxygen-16's exceptional stability and spherical charge distribution.</p>

<h4>Calcium-40 (Z=20): Icosahedral Completion</h4>
<p>Ten α-particles arranged in an icosahedral structure—20 nucleons forming the most symmetric possible arrangement. This represents the completion of the first major nuclear shell and explains calcium-40's status as a doubly magic nucleus.</p>

<h3>Shell Closure and Magic Numbers</h3>
<p>Nuclear magic numbers correspond to the completion of geometric shells:</p>
<ul>
  <li><strong>Z=2:</strong> Single α-particle (monomer)</li>
  <li><strong>Z=8:</strong> Tetrahedral shell (4 α-particles)</li>
  <li><strong>Z=20:</strong> Icosahedral shell (10 α-particles)</li>
  <li><strong>Z=28:</strong> Double shell (icosahedral core + cubic overlay)</li>
  <li><strong>Z=50:</strong> Triple shell (complex geometric arrangement)</li>
</ul>

<p>Each shell closure represents a point where the nuclear geometry is complete and symmetric, conferring exceptional stability.</p>

<h3>Geometric Stability Mechanisms</h3>
<p>Closed nuclear shells are stable due to several geometric factors:</p>

<h4>Maximized Bonding Networks</h4>
<p>Symmetric arrangements maximize the number of α-α bonds. A tetrahedral oxygen-16 has 6 bonds between its 4 α-particles, while an asymmetric arrangement would have fewer connections and higher energy.</p>

<h4>Uniform Stress Distribution</h4>
<p>Symmetric geometries distribute nuclear forces evenly, with no weak points or stress concentrations. This makes the nucleus resistant to deformation and excitation.</p>

<h4>Spherical Symmetry</h4>
<p>Closed shells approximate spherical shapes, minimizing surface area for a given volume. This reduces surface energy and makes the nucleus maximally compact.</p>

<h3>Nuclear Reactions as Geometric Rearrangements</h3>
<p>Nuclear reactions can be understood as rearrangements of geometric structures:</p>

<h4>Alpha Decay</h4>
<p>Heavy nuclei with incomplete shells can reduce their energy by ejecting an α-particle, returning to a more symmetric configuration.</p>

<h4>Fusion Reactions</h4>
<p>Light nuclei can fuse when their geometric structures can combine to form more stable arrangements. The triple-α process (3 He-4 → C-12) creates a triangular arrangement from three individual α-particles.</p>

<h4>Fission</h4>
<p>Very heavy nuclei become unstable when their geometric structure can no longer maintain coherence. They split into smaller, more stable geometric units.</p>

<h3>Predictions of the Geometric Model</h3>
<p>The geometric perspective makes several testable predictions:</p>

<h4>Enhanced Stability at Z=6, 14</h4>
<p>Carbon-12 and silicon-28 should show enhanced stability due to their roles as intermediate geometric closures (triangular and cube+octahedral arrangements).</p>

<h4>Cluster Decay Patterns</h4>
<p>Magic nuclei should preferentially decay into their constituent α-clusters when excited to high energies, revealing their underlying geometric structure.</p>

<h4>Transition Probabilities</h4>
<p>Electric quadrupole transitions should be suppressed in closed-shell nuclei due to their spherical symmetry, while enhanced in nuclei with incomplete shells.</p>

<h3>Connection to Nuclear Astrophysics</h3>
<p>The geometric model provides insights into stellar nucleosynthesis:</p>
<ul>
  <li>Magic nuclei serve as "stepping stones" in the s-process and r-process</li>
  <li>Geometric stability explains abundance patterns in stellar spectra</li>
  <li>Shell closures determine nuclear reaction rates in stellar cores</li>
</ul>

<h3>Relationship to Atomic Structure</h3>
<p>The same geometric principles that govern nuclear structure also determine atomic electron shells. The nucleus provides a geometric template around which electron orbitals organize, explaining the connection between nuclear magic numbers and chemical periodicity.</p>

<p><strong>Equation of record:</strong> Nuclear_stability ∝ geometric_symmetry × shell_closure_factor, where maximum stability occurs at Platonic solid completions.</p>

<p><strong>Glossary addendum:</strong> α-clusters; Platonic progression; shell closure; geometric stability; nuclear magic numbers.</p>

<h3>How this section ties forward/back</h3>
<ul>
  <li>Extends the magic number analysis from S11.1 to detailed nuclear structure</li>
  <li>Connects nuclear geometry to atomic structure described in S18.1</li>
  <li>Provides foundation for understanding chemical periodicity and bonding</li>
</ul>""",
        "figure_id": "fig-nuclear-geometry",
        "figure_src": "results/figs/nuclear_platonic_progression.png",
        "figure_caption": "Figure: Platonic progression of nuclear structure from α-particle to icosahedral calcium-40",
        "notebook_id": "nuclear_geometric_structure"
    }
]

# Read the current file
file_path = "/home/rftuser/omega_document/admin_portal/static/html/standalone/rft-volume2-rc12.html"

with open(file_path, 'r', encoding='utf-8') as f:
    content = f.read()

# Find the insertion point (before </article>)
insertion_point = content.find('      </article>')

if insertion_point == -1:
    print("ERROR: Could not find insertion point")
    exit(1)

# Generate the sections HTML
sections_html = ""
for section in sections_data:
    section_html = f"""
<h2 id="{section['id']}">{section['title']}</h2>

{section['content']}

<figure id="{section['figure_id']}">
  <img src="{section['figure_src']}" alt="{section['figure_caption'].replace('Figure: ', '')}" />
  <figcaption>{section['figure_caption']}</figcaption>
</figure>

<p>
  <a class="nb-dl" data-nb="{section['notebook_id']}" href="results/nb/{section['notebook_id']}.zip" download="{section['notebook_id']}.zip">📦 Reproduce this figure</a>
</p>

"""
    sections_html += section_html

# Insert the sections
new_content = content[:insertion_point] + sections_html + content[insertion_point:]

# Write back to file
with open(file_path, 'w', encoding='utf-8') as f:
    f.write(new_content)

print(f"✅ Added {len(sections_data)} comprehensive research sections to the HTML document")
print(f"File size: {len(new_content) / 1024 / 1024:.2f} MB")