# C9 Pre-Registration (SP99-TEST Blind Validation)

**Date**: 2025-11-09
**Config**: `config/global_c9.json`
**SHA256**: `<TBD after TRAIN grid search completes>`

## Frozen Parameters (TRAIN-optimized)

```json
{
  "mode_flattening": {
    "beta0": <TBD>,
    "beta1": <TBD>,
    "beta2": <TBD>
  },
  "mode_shelf": {
    "A_shelf": <TBD>,
    "p": <TBD>
  },
  "mode_core": {...},
  "mode_spiral": {...}
}
```

## Predicted TEST Performance (20% RMS threshold)

Based on TRAIN results, we pre-register the following predictions for SP99-TEST (34 galaxies):

### TRAIN Baseline (65 galaxies)
- **TRAIN pass@20%**: __/65 = __.__%
- **Wilson 95% CI**: [__%, __%]
- **Predicted TEST pass (n=34)**: [floor(34×CI_low), ceil(34×CI_high)]

### Primary Metrics
- **Pass rate**: __% to __% (predicted band from Wilson CI)
- **Median RMS**: __%–__%
- **Mean RMS**: __%–__%

### Fairness Comparisons
- **RFT > MOND wins**: ≥ __% of head-to-head comparisons
- **RFT > NFW wins**: ≥ __% (accounting for NFW's k=2 per-galaxy params)
- **BIC advantage**: RFT wins ≥ __% of BIC comparisons vs NFW

### Subgroup Performance
- **LSB pass rate**: ≥ __%
- **HSB pass rate**: ≥ __%
- **Bulge galaxies**: ≥ __% pass
- **No-bulge galaxies**: ≥ __% pass

## Acceptance Criteria

### Success (Target)
- TEST pass@20% ≥ 40-50%
- RFT > MOND in ≥ 60% of comparisons
- No systematic failures in LSB vs HSB

### Excellent (Stretch)
- TEST pass@20% ≥ 55%
- Median RMS ≤ 25%
- BIC wins vs NFW ≥ 50%

## Pre-Registration Lock

**Locked at**: `<UTC timestamp>`
**Git commit**: `<commit hash>`
**Git tag**: `c9-pre`

---

**Methodology**:
- TRAIN set (65 galaxies) used for grid search only
- TEST set (34 galaxies) never seen during optimization
- Zero per-galaxy tunables (k=0) maintained
- Manifest-scoped aggregation prevents data leakage
- Config frozen with SHA256 before TEST unblinding

**Falsifiability**:
If TEST pass@20% < 35% OR RFT < MOND in >50% of comparisons, C9 hypothesis is rejected.
