# RFT v2 — Galaxy Rotation Curves (Predictive, k=0)

[![CI](https://github.com/RFT-Cosmology/rft-v2-galaxy-rotations/workflows/CI/badge.svg)](https://github.com/RFT-Cosmology/rft-v2-galaxy-rotations/actions)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.XXXXXXX.svg)](https://doi.org/10.5281/zenodo.XXXXXXX)

**Version:** v2.2.2 (Tutorial Release)
**Frozen config:** `rc-v2-green-20pct` (commit `3428db0f`)
**Main result:** 58.8% pass@20% on TEST (20/34) with zero per-galaxy tuning (k=0).
**Fair baselines (k=0):** NFW_global 52.9% (18/34); MOND 23.5% (8/34).
**Supplement:** NFW_fitted (k=2 per galaxy) 82.4% (28/34); NFW_halo variant 29.4% (10/34).

---

## 🎓 NEW: Interactive Tutorial (v2.2.2)

**Want to learn about RFT v2 interactively?** We now include a comprehensive tutorial!

```bash
# Launch the tutorial (one command)
python3 tutorial/launch_tutorial.py
```

Or double-click `tutorial/launch_tutorial.bat` (Windows) or `tutorial/launch_tutorial.sh` (Mac/Linux).

The tutorial includes:
- 📚 **Physics background** - Dark matter problem, rotation curves, three paradigms
- 🔬 **Methodology** - k=0 fairness, TRAIN/TEST splits, statistical tests
- ▶️ **Hands-on exercises** - Run the auditor, explore galaxies
- 📊 **Result interpretation** - Understand the 58.8% pass rate
- ❓ **FAQ** - Physics, methods, software, troubleshooting

**See [`tutorial/README.md`](tutorial/README.md) for complete tutorial documentation.**

---

## 🔍 For Auditors: Independent Verification

**Want to verify our claims independently?** We provide a single-script auditor:

```bash
python3 audit/audit_all.py
```

This comprehensive auditor:
- ✅ Verifies all core claims (58.8%, 52.9%, 23.5%)
- ✅ Validates statistical tests (z-tests, p-values, Wilson CIs)
- ✅ Checks data integrity (TRAIN/TEST splits, parameter counts)
- ✅ Detects red flags (data leakage, p-hacking)
- ✅ Generates detailed audit report

**Requirements**:
- Python 3.7+ (uses f-strings and pathlib)
- Zero external dependencies for verification
- Full solver requires numpy/scipy (see requirements.txt)

**Important**: Run from repository root directory for correct file path resolution.

**See [`audit/README.md`](audit/README.md) for complete documentation.**

---

## Quick Start (One Command)

```bash
./RUNME.sh
```

This verifies:
1. ✅ Baseline lock (numbers match frozen publication)
2. ✅ Fairness pack (head-to-head, Wilson CIs)
3. ✅ Stability analysis (±10% parameter perturbations)
4. ✅ Headline table print

**Expected runtime:** 30-60 seconds
**Requirements:** Python 3.11+, pip

---

## What's Inside

### Core Results
- **RFT v2 TEST**: 20/34 pass@20% (58.8%) with 6 global parameters, k=0 per-galaxy
- **NFW_global TEST**: 18/34 pass@20% (52.9%) with 2 global parameters, k=0 per-galaxy
- **MOND TEST**: 8/34 pass@20% (23.5%) with 1 canonical parameter, k=0 per-galaxy

### Statistical Tests
- **RFT vs NFW_global**: z=2.44, **p=0.015** (statistically significant)
- **RFT vs MOND**: z=2.96, **p=0.003** (highly significant)
- **Wilson 95% CI**: RFT [42%, 74%], NFW [17%, 46%]

### LSB Dominance
- **LSB galaxies** (v_max < 120 km/s, n=15): RFT 66.7%, NFW 0.0%, MOND 0.0%
- **HSB galaxies** (v_max ≥ 120 km/s, n=19): RFT 52.6%, NFW 52.6%, MOND 42.1%

### Stability
- **All 12 perturbations** (±10% on each parameter): 58.8% maintained (zero degradation)

---

## Repository Structure

```
rft-v2-galaxy-rotations/
├── LICENSE                       # MIT license
├── README.md                     # This file
├── CITATION.cff                  # Citation metadata
├── requirements.txt              # Python dependencies
├── environment.yml               # Conda environment
├── Makefile                      # Convenience targets
├── RUNME.sh                      # One-click verification
│
├── scripts/
│   ├── audit_baselines.py        # Gate 0: baseline lock (CI enforced)
│   ├── verify_numbers.py         # Headline table verification
│   ├── generate_fairness_pack.py # Head-to-head & statistical tests
│   └── generate_stability_analysis.py  # ±10% perturbations
│
├── baselines/results/
│   ├── nfw_global_test_baseline.json   # Fair NFW (k=0)
│   ├── nfw_test_baseline.json          # Supplementary variants
│   └── mond_test_baseline.json         # Canonical MOND
│
├── results/v2.1_refine/
│   └── v2.1_test_results.json          # RFT v2 TEST results
│
├── app/static/data/
│   ├── v2_fairness_pack.json           # Generated by scripts
│   └── v2_stability.json               # Generated by scripts
│
├── config/
│   └── global_rc_v2_frozen.json        # Frozen parameter set
│
├── paper/
│   ├── main.tex                        # arXiv paper skeleton
│   └── refs.bib                        # Bibliography
│
└── .github/workflows/
    ├── ci.yml                          # CI: lint, test, verify
    └── release.yml                     # Auto-package on tags
```

---

## Reproduce Manually

### 1. Install Dependencies

```bash
# Option A: pip
python3 -m pip install -r requirements.txt

# Option B: Conda
conda env create -f environment.yml
conda activate rft-v2
```

### 2. Run Baseline Lock (Gate 0)

```bash
python3 scripts/audit_baselines.py
```

Expected output:
```
✅ rft.pass_20: 20/34 (matches frozen)
✅ nfw_global.pass_20: 18/34 (matches frozen)
✅ mond.pass_20: 8/34 (matches frozen)
✅ BASELINE LOCK VERIFIED
```

### 3. Generate Fairness Pack

```bash
python3 scripts/generate_fairness_pack.py \
  --rft results/v2.1_refine/v2.1_test_results.json \
  --nfw baselines/results/nfw_global_test_baseline.json \
  --mond baselines/results/mond_test_baseline.json \
  --out app/static/data/v2_fairness_pack.json
```

### 4. Generate Stability Analysis

```bash
python3 scripts/generate_stability_analysis.py \
  --frozen-config config/global_rc_v2_frozen.json \
  --out app/static/data/v2_stability.json
```

### 5. Verify Headline Numbers

```bash
python3 scripts/verify_numbers.py
```

---

## Make Targets

```bash
make verify      # Run RUNME.sh
make fairness    # Generate fairness pack only
make stability   # Generate stability analysis only
make clean       # Remove generated files
```

---

## Citation

If you use this code or results, please cite:

```bibtex
@software{rft_v2_2025,
  author = {{RFT Cosmology Project}},
  title = {RFT v2: Predictive Geometry-Only Rotation Curves},
  version = {1.0.0},
  date = {2025-11-10},
  url = {https://github.com/rft-cosmology/rft-v2-galaxy-rotations},
  doi = {10.5281/zenodo.XXXXXXX}
}
```

And the SPARC data:

```bibtex
@article{lelli2016sparc,
  title={SPARC: Mass Models for 175 Disk Galaxies with Spitzer Photometry and Accurate Rotation Curves},
  author={Lelli, F. and McGaugh, S. S. and Schombert, J. M.},
  journal={The Astronomical Journal},
  volume={152},
  number={6},
  pages={157},
  year={2016},
  doi={10.3847/0004-6256/152/6/157}
}
```

---

## Support

- **Website**: https://rft-cosmology.com
- **Paper**: arXiv:XXXX.XXXXX (to appear)
- **Issues**: https://github.com/rft-cosmology/rft-v2-galaxy-rotations/issues
- **Email**: research@rft-cosmology.com

---

## License

MIT License - see LICENSE file for details.

---

**Last Updated**: 2025-11-10
**Status**: Publication Ready ✅
